package gov.va.vinci.dart.biz;

import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.service.DartObjectFactory;

import java.util.Comparator;
import java.util.List;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;

@Entity
@Table(name = "DocumentTemplate", schema = "hib")
public class DocumentTemplate extends ReferenceObject {

	@Column(name="location", columnDefinition = "BIT", length = 1)
	protected boolean location;

	@Column(name="participant", columnDefinition = "BIT", length = 1)
	protected boolean participant;

	@Column(name="principalinvestigator", columnDefinition = "BIT", length = 1)
	protected boolean principalInvestigator;

	@Column(name="administrator", columnDefinition = "BIT", length = 1)
	protected boolean administrator;

 	@Column(name="activitytype")
	protected String activityType;

 	@Column(name="sortorder")
	protected int sortOrder;

	@ManyToMany(fetch=FetchType.LAZY)
	@JoinTable(
		      name="documenttemplateworkflowtemplate", schema="hib",
		      joinColumns={@JoinColumn(name="documenttemplateid", referencedColumnName="ID")},
		      inverseJoinColumns={@JoinColumn(name="workflowtemplateid", referencedColumnName="ID")})
	Set<WorkflowTemplate> workflowTemplates;
 	
	@ManyToMany(fetch=FetchType.LAZY)
	@JoinTable(
		      name="amendmentdocumenttemplateworkflowtemplate", schema="hib",
		      joinColumns={@JoinColumn(name="documenttemplateid", referencedColumnName="ID")},
		      inverseJoinColumns={@JoinColumn(name="workflowtemplateid", referencedColumnName="ID")})
	Set<WorkflowTemplate> amendmentWorkflowTemplates;
 	

	public static List<DocumentTemplate> listAll() {
		return DartObjectFactory.getInstance().getDocumentTemplateDAO().listAll();
	}
	
	public static DocumentTemplate findById(final int documentTemplateId) throws ObjectNotFoundException {
		return DartObjectFactory.getInstance().getDocumentTemplateDAO().findById(documentTemplateId);
	}

	public boolean isLocation() {
		return location;
	}

	// TESTING ONLY
	public void setLocation(boolean location) {
		this.location = location;
	}

	public boolean isParticipant() {
		return participant;
	}

	// TESTING ONLY
	public void setParticipant(boolean participant) {
		this.participant = participant;
	}
	
	public boolean isAdministrator() {
		return administrator;
	}

	// TESTING ONLY
	public void setAdministrator(boolean administrator) {
		this.administrator = administrator;
	}

	public boolean isPrincipalInvestigator() {
		return principalInvestigator;
	}

	public String getActivityType() {
		return activityType;
	}

	public void setActivityType(final String activityType) {
		this.activityType = activityType;
	}
	
	public int getSortOrder() {
		return sortOrder;
	}
	
	public void setSortOrder(final int sortOrder) {
		this.sortOrder = sortOrder;
	}

	public Set<WorkflowTemplate> getWorkflowTemplates() {
		return workflowTemplates;
	}

	public Set<WorkflowTemplate> getAmendmentWorkflowTemplates() {
		return amendmentWorkflowTemplates;
	}
	
	
	@Override 
	public boolean equals(Object obj) {
		if (obj == null) {
			return false;
		}
		
		if ((obj instanceof DocumentTemplate) == false) {	//TODO: may need to use isAssignableFrom()
			return false;
		}
		
		return this.getId() == ((DocumentTemplate)obj).getId();	//compare the id column
	}
	
	
	public static Comparator getComparator() {
		return new Comparator(){

			@Override
			public int compare(Object o1, Object o2) {
				if (o1 == null) {
					if (o2 != null) {
						return 1;
					}
					else {
						return 0;
					}
				}
				else {
					if (o2 == null) {
						return -1;
					}
						
					if ((o1 instanceof DocumentTemplate) == false) {
						return 0;
					}
					if ((o2 instanceof DocumentTemplate) == false) {
						return 0;
					}
					
					DocumentTemplate ev1 = (DocumentTemplate)o1;
					DocumentTemplate ev2 = (DocumentTemplate)o2;
	
					if (ev1.getSortOrder() == ev2.getSortOrder()) {
						return 0;
					}
					
					return ev1.getSortOrder() < ev2.getSortOrder() ? -1 : 1;
				}
			}
		};
	}
}
